/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.modelo.obj.compras;

import ec.gob.sri.anexo.texto.util.StringUtil;
import ec.gob.sri.dimm.api.modelo.persistencia.Importable;
import ec.gob.sri.dimm.api.modelo.validacion.ResultadoValidacion;
import ec.gob.sri.dimm.ats.modelo.obj.Iva;
import ec.gob.sri.dimm.ats.modelo.obj.Periodo;
import ec.gob.sri.dimm.ats.modelo.obj.Sujeto;
import ec.gob.sri.dimm.ats.modelo.util.Constantes;
import ec.gob.sri.dimm.ats.modelo.util.Util;
import ec.gob.sri.dimm.data.impl.UtilCatalogosATS;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Proveedor
extends Sujeto
implements Importable {
    private static final long serialVersionUID = -7165096025356786368L;
    public static final String C_PARTE_RELACIONADA = "descripcionTipoProveedor";
    private boolean parteRelacionada = false;

    @Override
    public Proveedor crearCopiaEdicion() {
        Proveedor copia = new Proveedor();
        copia.setTipoIdentificacion(super.getTipoIdentificacion());
        copia.setIdentificacion(super.getIdentificacion());
        copia.setDescripcionTipoIdentificacion(super.getDescripcionTipoIdentificacion());
        copia.setTipoProveedor(this.tipoProveedor);
        copia.setDescripcionTipoProveedor(this.descripcionTipoProveedor);
        copia.setParteRelacionada(this.parteRelacionada);
        copia.setRazonSocial(this.razonSocial);
        copia.setPropietario(this.propietario);
        return copia;
    }

    @Override
    public void actualizarInformacion(Sujeto copiaEdicion) {
        Proveedor proveedor = (Proveedor)copiaEdicion;
        this.setTipoProveedor(proveedor.getTipoProveedor());
        this.setDescripcionTipoProveedor(proveedor.getDescripcionTipoProveedor());
        this.setParteRelacionada(proveedor.parteRelacionada);
        this.setRazonSocial(proveedor.razonSocial);
        super.actualizarInformacion(copiaEdicion);
    }

    @Override
    protected ResultadoValidacion validacionExtra(ResultadoValidacion resultado) {
        Periodo periodo = ((Iva)this.getRaizModelo()).periodo;
        return this.validarTipoProveedorPorPeriodoYTipoDeIdentificacion(resultado, periodo);
    }

    private ResultadoValidacion validarTipoProveedorPorPeriodoYTipoDeIdentificacion(ResultadoValidacion resultado, Periodo periodo) {
        if ("P".equals(this.getTipoIdentificacion()) && periodo.isPeriodoDesdeEnero2013() && StringUtil.isNullOrEmpty((String)this.getTipoProveedor())) {
            return resultado.fallarValidacion("Debe seleccionar el tipo de proveedor");
        }
        resultado = this.validarRazonSocial(periodo, "proveedor", resultado);
        return resultado;
    }

    @Override
    public Object importar(Element elemento, Map<String, Element> mapaData) {
        NodeList valorList = elemento.getElementsByTagName("tpIdProv");
        Element eValor = (Element)valorList.item(0);
        this.setTipoIdentificacion(UtilCatalogosATS.crearInstancia().obtenerTipoIdentificacionSecuencia("1", eValor.getTextContent().trim()));
        this.setDescripcionTipoIdentificacion(Constantes.CATALOGOS_SUJETO.get(this.getTipoIdentificacion()));
        valorList = elemento.getElementsByTagName("idProv");
        eValor = (Element)valorList.item(0);
        this.setIdentificacion(eValor.getTextContent().trim());
        if ("P".equals(this.getTipoIdentificacion())) {
            if (Util.existeElementoImportar(elemento, "tipoProv")) {
                valorList = elemento.getElementsByTagName("tipoProv");
                eValor = (Element)valorList.item(0);
                this.setTipoProveedor(eValor.getTextContent().trim());
                this.setDescripcionTipoProveedor(UtilCatalogosATS.obtenerNombreDetalleCatalogo((String)"TIPOSIDPROV", (String)this.getTipoProveedor()));
            }
            if (Util.existeElementoImportar(elemento, "denoProv")) {
                valorList = elemento.getElementsByTagName("denoProv");
                eValor = (Element)valorList.item(0);
                this.setRazonSocial(eValor.getTextContent().trim());
            }
        }
        if (Util.existeElementoImportar(elemento, "parteRel")) {
            valorList = elemento.getElementsByTagName("parteRel");
            eValor = (Element)valorList.item(0);
            this.setParteRelacionada(Util.importarBooleano(eValor));
        }
        return this;
    }

    public boolean isParteRelacionada() {
        return this.parteRelacionada;
    }

    public String getParteRelacionada() {
        return this.parteRelacionada ? "SI" : "NO";
    }

    public void setParteRelacionada(boolean parteRelacionada) {
        boolean oldValue = this.parteRelacionada;
        this.parteRelacionada = parteRelacionada;
        this.firePropertyChange(C_PARTE_RELACIONADA, oldValue, this.parteRelacionada);
    }
}

